//
//  MCMultiKeyArrayController.h
//  MCApplication
//
//  Created by Michael Clark on 19/09/2005.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MCArrayController.h"

/*!
    @class       MCMultiKeyArrayController 
    @superclass  MCArrayController 
    @abstract    Allows the observing of multiple arrays on a given object
    @discussion  Given an object, and an array of keys returning arrays on the object this class will observe all keys and update it's content when any of them change.  At the moment this object will not be able to handle inserting or removing from the observed object because it will not know which key to apply the change to.
*/


@interface MCMultiKeyArrayController : MCArrayController {
	id         __object;
	NSArray*   __arrayKeys; // The keys that return arrays on __object
	
	id   __dndView; // View to pass to the DNDManager on drag operations
}





- (id)object;
- (void)setObject:(id)anObject;
- (NSArray *)arrayKeys;
- (void)setArrayKeys:(NSArray *)anArrayKeys;

- (id)dndView;
- (void)setDndView:(id)aDndView;

@end
